/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Config(modid="snowrealmagic")
@Mod.EventBusSubscriber(modid="snowrealmagic")
public final class ModConfig {
    @Config.Name(value="PlaceSnowInBlock")
    @Config.RequiresMcRestart
    public static boolean placeSnowInBlock = true;
    @Config.Name(value="ReplaceSnowWorldGen")
    public static boolean replaceSnowWorldGen = true;
    @Config.Name(value="SnowWorldGenPriority")
    public static int snowWorldGenPriority = 5;
    @Config.Name(value="SnowGravity")
    public static boolean snowGravity = true;
    @Config.Name(value="SnowAlwaysReplaceable")
    public static boolean snowAlwaysReplaceable = true;
    @Config.Name(value="SnowAccumulationDuringSnowstorm")
    public static boolean snowAccumulationDuringSnowstorm = true;
    @Config.Name(value="SnowAccumulationDuringSnowfall")
    public static boolean snowAccumulationDuringSnowfall = false;
    @Config.Name(value="ThinnerBoundingBox")
    public static boolean thinnerBoundingBox = true;
    @Config.Name(value="ParticleThroughLeaves")
    public static boolean particleThroughLeaves = true;
    @Config.Name(value="SnowMakingIce")
    public static boolean snowMakingIce = true;
    @Config.Name(value="SnowOnIce")
    public static boolean snowOnIce = false;
    @Config.Name(value="SnowNeverMelt")
    public static boolean snowNeverMelt = false;
    @Config.Ignore
    public static final Set<ResourceLocation> snowLoggableBlocksSet = Sets.newHashSet();
    @Config.Ignore
    public static final Set<ResourceLocation> yOffsetBlocksSet = Sets.newHashSet();
    @Config.RequiresMcRestart
    @Config.Name(value="snowLoggableBlocksV2")
    public static String[] snowLoggableBlocks = new String[]{"/(biomesoplenty|xlfoodmod|weeeflowers):.+(flower|mushroom|grass|plant|bamboo|vanilla)/", "defiledlands:scuronotte", "defiledlands:blastem", "/ferdinandsflowers:.+(flower|double|desert|ouch|fungus|dark)/", "/greenery:plant\\/upland\\/.+/", "/harvestcraft:.*garden.*/", "/notreepunching:loose_rock\\/.+/", "/(pyrotech|pyrotech_compat):.*rock.*/", "/plants2:.*(cosmetic|desert|double|harvest|bushling).*/"};
    @Config.RequiresMcRestart
    public static String[] yOffsetBlocks = new String[]{"/notreepunching:loose_rock\\/.+/", "/(pyrotech|pyrotech_compat):.*rock.*/"};

    private ModConfig() {
        throw new UnsupportedOperationException("No instance for you");
    }

    @SubscribeEvent
    public static void onConfigReload(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("snowrealmagic")) {
            ConfigManager.sync((String)"snowrealmagic", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static void postInit() {
        new Thread(() -> {
            ModConfig.filterBlocks(snowLoggableBlocksSet, snowLoggableBlocks);
            ModConfig.filterBlocks(yOffsetBlocksSet, yOffsetBlocks);
        }).start();
    }

    private static void filterBlocks(Set<ResourceLocation> set, String[] array) {
        set.clear();
        for (String s : array) {
            if (s.startsWith("/") && s.endsWith("/")) {
                Predicate<String> pattern = Pattern.compile("^" + s.substring(1, s.length() - 1) + "$").asPredicate();
                for (Block block : ForgeRegistries.BLOCKS) {
                    if (!pattern.test(block.getRegistryName().toString())) continue;
                    set.add(block.getRegistryName());
                }
                continue;
            }
            ResourceLocation id = new ResourceLocation(s);
            if (!ForgeRegistries.BLOCKS.containsKey(id)) continue;
            set.add(id);
        }
    }
}

